<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\Collection;

use Erlage\Photogram\Data\Common\CommonQueries;
use Erlage\Photogram\Data\Tables\Post\PostSaveTable;
use Erlage\Photogram\Data\Models\Post\Save\PostSaveModel;

final class CollectionModelHelper
{
    public static function deleteDependencies(CollectionModel $collectionModel): void
    {
        /**
         * @var PostSaveModel[]
         */
        $postSaveModels = CommonQueries::beansWithMatchingPredicates(
            PostSaveTable::getTableName(),
            array(
                PostSaveTable::SAVED_TO_COLLECTION_ID => $collectionModel -> getId(),
            )
        );

        foreach ($postSaveModels as $postSaveModel)
        {
            $postSaveModel -> delete();
        }
    }
}
